IF NOT EXISTS(
	SELECT 
		1
	FROM 
		 sys.tables 
	WHERE 
		NAME = 'EST_PROD_TBL_DESC_QTDE' )
BEGIN
	SET ANSI_NULLS ON

	SET QUOTED_IDENTIFIER ON

	CREATE TABLE [dbo].[EST_PROD_TBL_DESC_QTDE](
		[CD_EMP] [int] NOT NULL,
		[CD_TBL_DESC_QTDE] [int] NOT NULL,
		[DS_TBL_DESC_QTDE] [nvarchar](100) NOT NULL,
		[CD_TP_DESCONTO] [int] NOT NULL,
		[CD_USU] [int] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
		[DT_ULT_ALT] [datetime] NULL,
		[STS_TBL_DESC] [int] NULL,
		[QTDE_PAGUE] [int] NULL,
		[QTDE_LEVE] [int] NULL,
	 CONSTRAINT [PK_EST_PROD_TBL_DESC_QTDE] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_TBL_DESC_QTDE] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]



	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_QTDE_GLB_TP_DESCONTO] FOREIGN KEY([CD_TP_DESCONTO])
	REFERENCES [dbo].[GLB_TP_DESCONTO] ([CD_TP_DESCONTO])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_QTDE_GLB_TP_DESCONTO]


	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_QTDE_GLB_USU] FOREIGN KEY([CD_USU])
	REFERENCES [dbo].[GLB_USU] ([CD_USU])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_QTDE_GLB_USU]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_QTDE_PRC_EMP] FOREIGN KEY([CD_EMP])
	REFERENCES [dbo].[PRC_EMP] ([CD_EMP])

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_QTDE_PRC_EMP]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_QTDE_CD_TP_DESCONTO]  DEFAULT ((0)) FOR [CD_TP_DESCONTO]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE] ADD  DEFAULT ((0)) FOR [QTDE_PAGUE]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_QTDE] ADD  DEFAULT ((0)) FOR [QTDE_LEVE]

END

